/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.terminal.editor.TerminalEditor;
import com.aptana.terminal.hyperlink.IHyperlinkDetector;
import com.aptana.terminal.views.TerminalView;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;

public class HyperlinkDetector
implements IHyperlinkDetector {
    private static final IHyperlink[] NO_HYPERLINKS = new IHyperlink[0];
    private static Pattern GIT_FILEPATH_PATTERN = Pattern.compile("^(\\s*(Auto-merging|Removing|(delete|create) mode \\d+) (\\S+))|((\\S+)\\s+\\|\\s+((\\d+\\s+\\+*\\-*)|(Bin \\d+ \\-> \\d+ bytes)))|(rename (.+?) \\(\\d+%\\))");
    private static Pattern RENAME_PATTERN = Pattern.compile("(.+)\\{(.*?) => (.*?)\\}(.*)");

    public IHyperlink[] detectHyperlinks(String contents) {
        Matcher m = GIT_FILEPATH_PATTERN.matcher(contents);
        if (m.find()) {
            Matcher renameMatcher;
            int groupNum = 4;
            String filepath = m.group(groupNum);
            if (filepath == null) {
                groupNum = 6;
                filepath = m.group(groupNum);
            }
            if (filepath == null && (renameMatcher = RENAME_PATTERN.matcher(filepath = m.group(groupNum = 11))).find()) {
                filepath = String.valueOf(renameMatcher.group(1)) + renameMatcher.group(3) + renameMatcher.group(4);
            }
            if (filepath != null && !filepath.startsWith("..")) {
                int start = m.start(groupNum);
                int length = m.end(groupNum) - start;
                return new IHyperlink[]{new GitHyperlink((IRegion)new Region(start, length), filepath)};
            }
        }
        return NO_HYPERLINKS;
    }

    private static class GitHyperlink
    implements IHyperlink {
        private IRegion region;
        private String filepath;
        private Set<IPath> reposTried;

        GitHyperlink(IRegion region, String filepath) {
            this.region = region;
            this.filepath = filepath;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return this.filepath;
        }

        public void open() {
            try {
                this.reposTried = new HashSet<IPath>();
                File file = this.getFile();
                if (file == null) {
                    return;
                }
                IFileStore store = EFS.getStore((URI)file.toURI());
                if (store == null) {
                    return;
                }
                try {
                    IWorkbenchPage page = UIUtils.getActivePage();
                    if (page != null) {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)store);
                    }
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e);
                }
            }
            finally {
                this.reposTried = null;
            }
        }

        private File getFile() {
            Object relative;
            IWorkbenchPage page = UIUtils.getActivePage();
            if (page != null) {
                IViewReference[] viewRefs;
                IEditorReference[] refs;
                IEditorReference[] iEditorReferenceArray = refs = page.getEditorReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference ref = iEditorReferenceArray[n2];
                    if ("com.aptana.terminal.TerminalEditor".equals(ref.getId()) && (relative = this.getFileRelativeToWorkingDir(ref.getPart(false))) != null) {
                        return relative;
                    }
                    ++n2;
                }
                relative = viewRefs = page.getViewReferences();
                int n3 = viewRefs.length;
                n = 0;
                while (n < n3) {
                    File relative2;
                    IViewReference ref = relative[n];
                    if ("com.aptana.terminal.views.terminal".equals(ref.getId()) && (relative2 = this.getFileRelativeToWorkingDir(ref.getPart(false))) != null) {
                        return relative2;
                    }
                    ++n;
                }
            }
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n4 = 0;
            while (n4 < n) {
                IProject project = iProjectArray[n4];
                GitRepository repo = GitPlugin.getDefault().getGitRepositoryManager().getAttached(project);
                relative = this.getFileFromRepo(repo);
                if (relative != null) {
                    return relative;
                }
                ++n4;
            }
            return null;
        }

        private File getFileRelativeToWorkingDir(IWorkbenchPart part) {
            File relative;
            if (part == null) {
                return null;
            }
            IPath workingDir = null;
            if (part instanceof TerminalView) {
                workingDir = ((TerminalView)part).getWorkingDirectory();
            } else if (part instanceof TerminalEditor) {
                workingDir = ((TerminalEditor)part).getWorkingDirectory();
            }
            if (workingDir == null) {
                return null;
            }
            IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(workingDir);
            if (container == null) {
                return null;
            }
            IProject project = container.getProject();
            GitRepository repo = GitPlugin.getDefault().getGitRepositoryManager().getAttached(project);
            if (this.filepath.startsWith("..") && repo != null && (relative = workingDir.append(this.filepath.substring(2)).toFile()).exists()) {
                return relative;
            }
            return this.getFileFromRepo(repo);
        }

        private File getFileFromRepo(GitRepository repo) {
            if (repo == null) {
                return null;
            }
            IPath wd = repo.workingDirectory();
            if (this.reposTried.contains(wd)) {
                return null;
            }
            this.reposTried.add(wd);
            File file = wd.append(this.filepath).toFile();
            if (file.exists()) {
                return file;
            }
            return null;
        }
    }
}

